/*------------------------------------------------------------------------------*
 *	File Name: 	ocStats.h								 						*
 *	Purpose:	C math functions that need stats structs					   	*
 *				This header is used in VC ocMath DLL as well as in OC files		*
 *  Creation:	3/15/2004, ML													* 
 *  	Copyright Originlab Corp. 2003, 2004, 2005								*
 *	Modification log															*
 *	Jay 04/20/04 CHANGE_OCMATH_MULTIPLE_LINER_REGRESSION						*
 *	Jean 05/10/04	ADD_STUDENTS_T												*
 *  Iris 5/12/04 ADD_W_TEST_FOR_181												*
 *	Jean 05/24/05	ADD_TWO_WAY_ANOVA											*
 *  Iris 06/08/04 REMOVE_N2_ARGUMENT_AND_CHANGE_TO_FLOAT_TYPE					*
 *	Max 06/13/04 RENAME_OCMATH_SHAPIRO_WILK_TEST								*
 *	Max 06/13/04 REMOVE_nInit&N1&N2&pA_ARGUMENT									*
 *	Max 03/16/05 REWRITE_ONEWAYANOVA_MEAN_COMPARISON							*
 *	Max 03/16/05 REWRITE_TWOWAYANOVA_MEAN_COMPARISON	                        *
 *  Ben 09/20/05 ADD_PDF_CDF                                                    *
 *  Ben 09/21/05 ADD_IN_CDF_RANDOM_NO                                           *
 *  Human 10/14/05 REPLACE_NORMINV                                              *
 *  Zachary  04/14/06  QA8482  PARAMETER_NSIZE_IS_NOT_USED_IN_NCBETACDF.	    *
 *  Zachary  04/18/06  REWRITE_NCTCDF											*
 *	Echo 7/5/06 MAKE_SEPERATED_VARIANCE_TEST									*
 *  Zachary 07/07/06 ADD_DEFAULT_VALUE_FOR_TAIL_OF_TINV							*
 *	Echo 3/23/07	REPLACED_BY_NAG												*
 *  Justin on 03/30/2007 MODIFY_FUNCTION_CATEGORY								*
 *	Echo 11/19/07	ROW_QUANTILE_CLEAN_CODE										*
 *	Echo 3/18/08	DUPLICATED_INPUT_VARIABLE									*
 *	Fisher 12/08/08 QA80-12735  SUPPORT_USER_SUPPLIED_BIN_VECTOR_IN_FREQCOUNTS	* 
 *  Derek 3/31/2010 OCMATH_FREQUENCY_COUNT_I                                    *
 *------------------------------------------------------------------------------*/      


#ifndef _OC_STATS_H
#define _OC_STATS_H
//////////////////////////////////////////////////////////////////////////

#include	"stats_types.h"


//////////////////////////////////////////////////////////
// function declarations
//////////////////////////////////////////////////////////
#ifdef _MSC_VER	   //VC
	#ifdef OCMATH_EXPORTS
		#define OCMATH_API __declspec(dllexport)
	/// TD 06-19-2008 QA80-10844 TRICTR_IN_VIEWER
	#elif  defined(MIN_OK_VERSION)
		#define OCMATH_API
	/// end QA80-10844 TRICTR_IN_VIEWER
	#else
		#define OCMATH_API __declspec(dllimport)
	#endif
	extern "C" {
#else //_MSC_VER
	#define OCMATH_API
	#pragma dll(ocMath)	// Assoicate all functions below to ocMath.dll which must be in the Origin EXE folder
#endif	//!_MSC_VER

#define STATS_ROUND_FACTOR1				10000 ///Echo 8/3/2004 Add for ANOVA2
#define MUL_REG_TOLERANCE				1e-20
#define SU_MIN_NPTS						2	///Minimum data points 
#define SA_MAX_CENSORED_LIST			20  ///Maxmum length of Censored value List of SA functions
#define SORT_ASCENDING					1
#define COX_MODEL_TOLERANCE				5e-6
#define COX_MODEL_ITERATIONS			100
#define	POWER1_TOL					    1e-6	///Sonic	12/22/04	Add for power1
#define POWER1_MAXITER					1e6	///Sonic	12/22/04	Add for power1
#define SAMPLESIZE_LARGEST				1000000	///Sonic	12/22/04	Add for SampleSize
#define MAX_KEN_TIES					100000//Maximun ties in kendall tau correlation
#define ROC_MAX_STATE_LIST				20	//Maxmum length of state value List of ROC function
#define ROC_THD_SIZE_SPEED				100 //Length of threshold in roc if speed mode is on
#define ROC_HYPO_AREA					0.5 //NULL Hypothesis that Area = ROC_AREA_HYPO, for asymptotic p-value computation
#define	STATS_DEFAULT_ALPHA				0.05

/**
*/
//OCMATH_API int ocmath_linear_fit(const double *pX, const double* pY, int nSize, FitParameter* pp);
//OCMATH_API int ocmath_linear_fit(const double *pX, const double* pY, int nSize, FitParameter* pp, const double* pSig = NULL, double* pchi2 = NULL, double* pq = NULL);


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//				Basic Functions: Descriptive Statistics, Percentile, Range, Quantile, Frenqucy Count, Non-Central CDFs									
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//Comments last updated by Stacy on 7/23/2009
/** >Statistics > Descriptive Statistics
	Remarks:
		Function to compute moments in data
	Example1:
		#include <stats_types.h> // need to include this before ocStats.h
		void ocmath_desc_stats_ex1()
		{
			Worksheet wks = Project.ActiveLayer();
			for(int ii = 0; ii < wks.GetNumCols(); ii++)
			{
				Dataset dd(wks, ii);
				DescStatResults dsr;
				vector vv = dd;
						
				ocmath_desc_stats(vv, vv.GetSize(), &dsr);
				Tree trTemp;
				TreeNode tr = trTemp.AddNode("DescStats");
				tr = dsr;
				printf("Col(%d) ------ \n", ii+1);
				out_tree(tr);
			}
		}
	Parameters:
		pData = [input] pointer to vector of data to be computed
		nSize = [input] vector size of pData;
		pResults = [output] pointer to struct to receive results
		pWt = [input] pointer to vector of weights, must be same size as pData if provided. 
			  If pWt is supplied and contains missing values, the corresponding elements in pData will also be considered missing
		dConfLevel = [input] confidence level to calculate confidence intervals LCL and UCL. Default value is 0.95.
		MomentDenFlag = [input] value indicates the variance divisor
						DS_SAS1_DOF(default): Den is dof, which is also the default algorithm in SAS
						DS_SAS2_N: Den is n;
						DS_SAS3_WDF: Den is Sum(weight) - 1; Skewness and Kurtosis are set to missing in this case
						DS_SAS4_WGT: Den is Sum(weight); Skewness and Kurtosis are set to missing in this case
						DS_NAG: Den is sum(weight) - Sum(weight^2) / sum(weight), which is the algorithm of nag. 
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.		
	Reference:
		1> Hays, W. L. 1973. Statistics for the social sciences. New York: Holt, Rinehart and Winston. 
		2> SAS help: DISTRIBUTION ANALYSIS: Method
		3> SAS help: WEIGHT statement

*/
OCMATH_API	int	ocmath_desc_stats(const double *pData, UINT nSize, DescStatResults *pResults, const double *pWt = NULL, double dConfLevel = 0.95, int MomentDenFlag = DS_SAS1_DOF);

/**$
			Function to compute descriptive statistics of multiple dataset
*/
/// Echo 3/18/08	DUPLICATED_INPUT_VARIABLE									*
//OCMATH_API	int	ocmath_desc_stats_ex(const double *pData, UINT nSize, const double* pIndex, UINT nIndex, const DescStatOptions *pOpt, DescStatResults *pResults, const double *pWt = NULL, double dConfLevel = 0.95, int MomentDenFlag = DS_SAS1_DOF, bool* pmultimodes = NULL);
OCMATH_API	int	ocmath_desc_stats_ex(const double *pData, UINT nSize, const double* pIndex, UINT nIndex, const DescStatOptions *pOpt, DescStatResults *pResults, const double *pWt = NULL, double dConfLevel = 0.95, bool* pmultimodes = NULL);

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_basic_summary_stats_(global_function)
*/
OCMATH_API	int	ocmath_basic_summary_stats(UINT nSize, const double *pData, int* pN, double* pMean, double* pSD = NULL, double* pSE = NULL, double* pVariance = NULL,  double* pSum = NULL, 
										   double* pSkewness = NULL, double* pKurtosis = NULL, double* pUSS = NULL, double* pCSS = NULL, double* pCOV = NULL, double* pMAD = NULL, 
										   int* pMissing = NULL, double* pWeightSum = NULL, double* pGMean = NULL,
										   int MomentDenFlag = DS_SAS1_DOF, const double *pWt = NULL);
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_opt_summary_stats_(global_function)
*/
OCMATH_API	int	ocmath_opt_summary_stats(UINT nSize, const double *pData, const double dConfLevel, double* pMode = NULL, bool* pmultimodes = NULL, double* pGSD = NULL, double* pLCL = NULL, double* pUCL = NULL,
										 double* pSDx2 = NULL, double* pSDx3 = NULL, 
										 int MomentDenFlag = DS_SAS1_DOF, const double *pWt = NULL);


///Cheney 2006-5-18  LLVC_ROW_DESC_STATS
//Comments last updated by Cheney on 2006-5-19
// Category last updated by Echo on 06/02/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_row_desc_stats_(global_function)
*/
///Echo 04/26/07 ADD_LCL_UCL
//OCMATH_API int ocmath_row_desc_stats(UINT nRows, UINT nCols, const double* pMat, double* pMean = NULL, double* pSd = NULL,  
									 //double* pSem = NULL, double* pMin = NULL, double* pMax = NULL, double* pSum = NULL, double* pN = NULL);
OCMATH_API int ocmath_row_desc_stats(UINT nRows, UINT nCols, const double* pMat, double* pMean = NULL, double* pSd = NULL,  
									 double* pSem = NULL, double* pMin = NULL, double* pMax = NULL, double* pSum = NULL, double* pN = NULL, double* pLCL = NULL, double* pUCL = NULL, int nMomentDenFlag = DS_SAS1_DOF);
///END ADD_LCL_UCL

///Cheney 2007-11-14 STATS_ON_ROW_SHOULD_SUPPORT_MORE_OPTION_AS_MAX_SAID
/**$
Return:
		Return OE_NOERROR if succeed, otherwise, non-zero error code is returned.
	See also:
		ocmath_row_desc_stats
*/
OCMATH_API int ocmath_row_desc_stats_ex(UINT nRows, UINT nCols, const double* pMat, double* pMean = NULL, double* pSd = NULL,  
									 double* pSem = NULL, double* pMin = NULL, double* pMax = NULL, double* pSum = NULL, 
									 double* pN = NULL, double* pLCL = NULL, double* pUCL = NULL, double* pVariance = NULL,
									 double* pSkewness = NULL, double* pKurtosis = NULL, double* pUSS = NULL, double* pCSS = NULL, 
									 double* pCOV = NULL, double* pMAD = NULL, int* pMissing = NULL, double* pGMean = NULL, 
									 double* pMode = NULL, bool* pmultimodes = NULL, double* pGSD = NULL, double* pSDx2 = NULL, 
									 double* pSDx3 = NULL, int nMomentDenFlag = DS_SAS1_DOF);
///end 	 STATS_ON_ROW_SHOULD_SUPPORT_MORE_OPTION_AS_MAX_SAID

///Cheney 2006-5-19  LLVC_ROW_QUANTILES
//Comments last updated by Cheney on 2006-5-19
// Category last updated by Echo on 06/02/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_row_quantiles_(global_function)
*/
///Echo 4/26/07 ADD_QUANTILE_METHOD
//OCMATH_API int ocmath_row_quantiles(UINT nRows, UINT nCols, const double* pMat, double* pMin = NULL,
									//double* pMax = NULL, double* pQ1 = NULL, double* pMedian = NULL, double* pQ3 = NULL);
OCMATH_API int ocmath_row_quantiles(UINT nRows, UINT nCols, const double* pMat, double* pMin = NULL,
									double* pMax = NULL, double* pQ1 = NULL, double* pMedian = NULL, double* pQ3 = NULL, int nInterpolate = INTERPOLATE_WEIGHT_AVER_RIGHT);
///END ADD_QUANTILE_METHOD
///end LLVC_ROW_QUANTILES

///Cheney 2007-11-14 STATS_ON_ROW_SHOULD_SUPPORT_MORE_OPTION_AS_MAX_SAID
/**$
Return:
		Return OE_NOERROR if succeed, otherwise, non-zero error code is returned.
	See also:
		ocmath_row_quantiles
*/
///Echo 11/19/07	ROW_QUANTILE_CLEAN_CODE
OCMATH_API int ocmath_row_quantiles_ex(UINT nRows, UINT nCols, const double* pMat, double* pMin = NULL, double* pMax = NULL, 
									   double* pQ1 = NULL, double* pMedian = NULL, double* pQ3 = NULL, int* piMin = NULL,
										int* piMax = NULL, double* pIQR = NULL, double* pRange = NULL, const double* pPercents = NULL, 
										UINT nPercentSize = 0, double* pMatPercentiles = NULL, int nInterpolate = INTERPOLATE_WEIGHT_AVER_RIGHT);
/*
OCMATH_API int ocmath_row_quantiles_ex(UINT nRows, UINT nCols, const double* pMat, double* pMin = NULL, double* pMax = NULL, 
									   double* pQ1 = NULL, double* pMedian = NULL, double* pQ3 = NULL, int* piMin = NULL,
										int* piMax = NULL, double* pIQR = NULL, double* pRange = NULL, const double* pPercents = NULL, 
										const int* pPercentSize = NULL, double* pMatPercentiles = NULL, int nInterpolate = INTERPOLATE_WEIGHT_AVER_RIGHT);
*/										
///end STATS_ON_ROW_SHOULD_SUPPORT_MORE_OPTION_AS_MAX_SAID
///end ROW_QUANTILE_CLEAN_CODE

//Comments last updated by Echo on 2008-6-2
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_percentiles_(global_function)
*/
OCMATH_API int ocmath_percentiles(const double *pData, const int nSize, const double* pPercents, const int nPercentSize, double *pPercentiles, int nInterpolate = INTERPOLATE_WEIGHT_AVER_RIGHT, const double *pWeight = NULL);


/**$
		Function to compute range statistics for a vector passing results in a structure.
	Parameters:
		pData=Input pointer to data for which the range is computed
		nSize=Input value of size of pData
		pRr=Output pointer to structure containing range results
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_range(const double *pData, const int nSize, RangeResults *pRr);

//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_quantiles_(global_function)
*/

OCMATH_API int ocmath_quantiles(const double* pData, UINT nSize, const QuantileOptions* opt, QuantileResults* res,
	 const double* pPercents = NULL, UINT nPercentSize = 0, double* pPercentiles = NULL,  const double *pWeight = NULL);


// Category last updated by Echo on 06/02/2008
/**# >Statistics>Descriptive Statistics
	Remarks:
		Function to calculate frequency count for discrete/categorical data. Frequency
		if computed for each value of input data.
	Example:
	Parameters:
		pSource = [Input] pointer to an array containing input data
		nSourceSize = [Input] size of an array containing input data
		pData = [Output] pointer to a array containing all non-duplucated data in input data.
						Size of pData is nSourceSize.please note that last (nSourceSize-nFreqs) values are NANUM;
		pFreqs = [Output] pointer to an array containing output frequencies corresponding to the pData
						Size of pFreqs is nSourceSize.please note that last (nSourceSize-nFreqs) values are NANUM;
		pnFreqs = [Output] Optional pointer to number of non-duplicated values in input data.
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_discrete_frequencies(const double* pSource, const UINT nSourceSize, double* pData, double* pFreqs, int* pnFreqs = NULL);

///Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_frequency_count_(global_function)
*/
/// Fisher 12/08/08         QA80-12735       SUPPORT_USER_SUPPLIED_BIN_VECTOR_IN_FREQCOUNTS 
OCMATH_API int  ocmath_frequency_count(double* pSource, UINT nSourceSize, FreqCountOptions* fcoOptions, 
									   double* pBinCenters, UINT nBinCenterSize, 
									   double* pAbsoluteCounts, UINT nAbsoluteCountSize, 
									   double* pCumulativeCounts = NULL, UINT nCumulativeCountSize = 0, int nOption = FC_STEPSIZE,
									   double* pBin = NULL, UINT nBinSize = 0);
// OCMATH_API int  ocmath_frequency_count(double* pSource, UINT nSourceSize, FreqCountOptions* fcoOptions, 
// 									   double* pBinCenters, UINT nBinCenterSize, 
// 									   double* pAbsoluteCounts, UINT nAbsoluteCountSize, 
// 									   double* pCumulativeCounts = NULL, UINT nCumulativeCountSize = 0, int nOption = FC_STEPSIZE);
/// End SUPPORT_USER_SUPPLIED_BIN_VECTOR_IN_FREQCOUNTS
///Echo 3/23/07	REPLACED_BY_NAG									   
///**$
		//Cumulative probability at T of the non-central t-distribution
	    //with DF degrees of freedom (may be fractional) and non-centrality
	    //parameter DELTA.
	//Example 
		//void test_non_central_t_test()
		//{
			//double p;
			//double t, df, delta;
			//int ifault;
			//t = 3;
			//df = 60;
			//delta = 1.5;
			//iErr = 0;
			//p = ocmath_non_central_t_cdf(&t, &df, &delta, &iErr); // p = 0.92439
			//printf("%.10f",p);
		//}	
	//Parameter:
		//t=Input pointer to t value
		//df=Input pointer to degree of freedom; df >= 0
		//delta=Input pointer to non-centrality parameter DELTA.
		//iErr=Input and Output pointer to error code
	//Return 
		//Returns cumulative probability at T of the non-central t-distribution
	//Reference:
		//ALGORITHM AS 243  APPL. STATIST. (1989), VOL.38, NO. 1
//
//*/


// Derek  3/31/2010  OCMATH_FREQUENCY_COUNT_I  

/** $
    Remarks: This function counts the occurrence frequencies of the numbers within range [nMin, nMax] in an INT array.
	           	
	Parameters:
		pSource = [input] pointer to the source data
		nSourceSize = [input] size of the source data  
		nMin = [input] lower bound of the range to be counted
		nMax = [input] upper bound of the range to be counted
		pCount = [output] the occurrence of each number within the range. pCount[0] represents the occurrence of nMin,
		         and pCount[nMax-nMin] represents nMax. Size of pCount should be (nMax-nMin+1), and the memory should be
				 allocated from external
	
	Return:
		status of the function call
		
	Example1:
	void ocmath_frequency_count_i_ex1()
	{
		int pSource[] = {0, 1, 3, 2, 1, -2, 2, 3, -1, 3, 4, 2, -2, 1, -4, 5, 3};
		int nSourceSize = 17;
		int nMin = -1, nMax = 3;
		int nSize = nMax - nMin + 1;
		UINT *pCount = (UINT *)malloc(nSize*sizeof(UINT));
        ocmath_frequency_count_i(pSource, nSourceSize, nMin, nMax, pCount);
		for(int ii = 0; ii < nSize; ii ++)
		{
			printf("pCount[%d]=%d\n", ii, pCount[ii]);
		}
		free(pCount);
	}

**/ 
/// END OCMATH_FREQUENCY_COUNT_I
OCMATH_API int ocmath_frequency_count_i(const int* pSource, UINT nSourceSize, int nMin, int nMax, UINT *pCount);

//OCMATH_API	double	ocmath_non_central_t_cdf(double* t, double* df, double* delta, int* iErr);
//
///**$
     	//Function to compute the cumulative probability of X for the non-central beta 
    	//distribution with parameters A, B and non-centrality LAMBDA 
	//Example:
		//void test_non_central_beta()
		//{
			//double x = 0.75;	
			//double a = 1.5;	
			//double b = 1.5;	
			//double Lambda = 0.5;	
			//int iErr;
			//double dR;
			//dR = ocmath_non_central_beta_cdf(&x, &a, &b, &Lambda, &iErr);
			//printf("%.10f",dR); //dR = 0.77048
		//}
	//Parameter:
		//pX=Input pointer to beta value; 0<=pX<=1
		//pA=Input pointer to the first parameter of required beta distribution; pA >= 0
		//pB=Input pointer to the second parameter of required beta distribution; pB >= 0
		//pLambda=Input pointer to non-centrality parameter Lambda. pLambda >= 0
		//iErr=Input and Output pointer to error code
	//Return 
		//Returns cumulative probability at X of the non-central beta-distribution
	//Reference:
     	//ALGORITHM AS226 APPL. STATIST. (1987) VOL. 36, NO. 2 
//*/
//OCMATH_API  double  ocmath_non_central_beta_cdf(double* pX, double* pA, double* pB, double* pLambda, int* iErr);
//
///**$
     	//Function to compute the cumulative probability of F for the non-central f 
    	//distribution with DF1 degree of freedom of numerator variance and DF2 degree 
		//of freedom of the denominator and non-centrality LAMBDA 
	//Example:
		//void run_non_central_f()
		//{	
			//double f = 26;	
			//double a = 1.5;	
			//double b = 1.5;	
			//double Lambda = 0.5;	
			//
			//int iErr;
			//double dR;
			//dR =  ocmath_non_central_f_cdf(&f, &a, &b, &Lambda, &iErr);
			//printf("%.10f",dR);//dR = 0.91749
		//}
	//Parameter:
		//pF=Input pointer to beta value; pX>=0
		//pDf1=Input pointer to the first parameter of required beta distribution; pDf1 >= 0
		//pDf2=Input pointer to the second parameter of required beta distribution; pDf2 >= 0
		//pLambda=Input pointer to non-centrality parameter Lambda. pLambda >= 0
		//iErr=Input and Output pointer to error code
	//Return 
		//Returns cumulative probability at X of the non-central beta-distribution
	//Reference:
     	//nag_prob_non_central_f_dist(g01gdc), NAG Manual
//*/
//OCMATH_API  double  ocmath_non_central_f_cdf(double* pF, double* pDf1, double* pDf2, double* pLambda, int* iErr);
	//
///**$
		//Approximates the quantile q for a studentized range
        //distribution having df degrees of freedom and dSize samples
        //for probability dP, 0.90 <= dP <= 0.99
	//Example:
		//void test_studentised_rang()
		//{
			//double ret1 = ocmath_inverse_studentized_range(3.4032, 57, 3);
			////ret1 = 0.9499;
		//}
	//Parameters:
		//dP=Input lower side cumulative probability. 0.90 <= p <= 0.99
		//df=Input degrees of freedom
		//dSize=Input number of samples	
		//iErr=Output error code
	//Return:
		//Returns studentized range statistic	
	//Reference:
		//Algorithm AS 190, Appl.Statist. (1983) Vol. 32, No2
//*/
//OCMATH_API	double	ocmath_studentized_range(double dP, double df, double dSize, int iErr=0);
//
///**$
		//Approximates the probability p for a studentized range
        //distribution having df degrees of freedom and dSize samples
        //for quantile dQ.
	//Example:
		//void test_studentised_rang()
		//{
			//double ret1 = ocmath_studentized_range(0.95, 57, 3);
			////ret1 = 3.4339;
		//}
	//Parameters:
		//dQ=Input upper limit of studentized range, lower limit is zero
		//df=Input degrees of freedom
		//dSize=Input number of samples
		//iErr=Output error code
	//Return:
		//Returns probability for studentized range
	//Reference:
		//Algorithm AS 190, Appl.Statist. (1983) Vol. 32, No2
//*/
//OCMATH_API	double	ocmath_inverse_studentized_range(double dQ, double df, double dSize, int iErr=0);
///END REPLACED_BY_NAG


/////////////////////////////////////////////////////////////////////////////////
//
//				Multiple Regression Functions									
//
/////////////////////////////////////////////////////////////////////////////////

//Comments last updated by Jack on 2008-7-22
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_linear_fit_(global_function)
*/
OCMATH_API int ocmath_linear_fit(const double* pX, const double* pY, int nSize, FitParameter* psFitParameter, const double* pWT = NULL, UINT nWTSize = 0, const LROptions* psLROptions = NULL, 
								 RegStats* psRegStats = NULL, RegANOVA* psRegANOVA = NULL, RegCalcInternal* psInternal = NULL,
								 double* pCov = NULL,  double* pCorr = NULL, uint nCovCorrRowSize = 0, uint nCovCorrColSize = 0);

//Comments last updated by Echo on 2008-6-2
/**# >Fitting		

	Exampl1:

	Remarks:
		Function to perform multiple linear regression. The function finds a QR decomposition
		of X. If R is of full rank, solution is obtained from the QR decomposition. If R is not 
		full rank, a solution is obtain by means of a singular value decomposion(SVD) of R
		If R is not full rank, STATS_ERROR_RANK_DEFICIENT is returned in addition to the solutions. 
		The computational engine is the NAG function nag_regsn_mult_linear (g02dac).
	Parameters:
		pX=Input matrix containing data points of the independent variables
		nOSizeN=Input the number of observations, n. n>=2
		nVSizeM=Input the total number of independent variables in the data set, m. m>=1
		pY=Input vector containing data points of dependent variable, size of pY = n
		pWT=Input vector containing weight of the data, all date in pWT should not less than zero
		nWTSize=Input the size of the weight, should be the same as nOSizeN
		psLROptions=Input struct for linear regression options 
		psFitParameter=Output pointer to structs to receive information on each fitting parameter
		nFitSize=Input the size of psFitParameter, should be nVSizeM + 1
		psRegStats=Optional output pointer to struct containing Regression statistics
		psRegANOVA=Optional output pointer to struct containing ANOVA statistics.
		pCov = Optional output pointer to covariance matrix of estimate
		pCorr = Optional output pointer to correlation matrix of estimate
		nCovCorrRowSize = Input row size of Covariance and Correlation matrix, which should be nVSizeM + 1
		nCovCorrColSize = Input column size of Covariance and Correlation matrix, which should be nVSizeM + 1 
		pH =[output] Optional output pointer to diagonal element of H, leverage  Size of the pH should be nOSizeN
		pSE=[output] Optional output pointer to standard error of mean predicted values. Size of the pSE should be nOSizeN
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_multiple_linear_regression(const double* pX, UINT nOSizeN, UINT nVSizeM, 
												 const double* pY, const double* pWT, UINT nWTSize, const LROptions* psLROptions, 
												 FitParameter* psFitParameter, UINT nFitSize, RegStats* psRegStats = NULL, RegANOVA* psRegANOVA = NULL,
												 double* pCov = NULL,  double* pCorr = NULL, uint nCovCorrRowSize = 0, uint nCovCorrColSize = 0,
												 double* pH = NULL, double* pSE = NULL);

/**$
	Remarks:
		Function to normalized X in order to support large X values in a small range in MR
		Devide X columns by SD of each column. i.e Let X = (X1, ..., Xp), Si=SD(Xi), i=1,...,p
		then nomalized X = (X1/S1, ..., Xp/Sp)
	Parameters:
		psLROptions=Input pointer to struct for linear regression options 
		pX=Input pointer to X.
		nOSizeN=Input the number of observations, n. n>=2
		nVSizeM=Input the total number of independent variables in the data set, m. m>=1
		pNormX=Output pointer to Normalized X.
		pS=Output pointer to vector (1/S1, ..., 1/Sp), Si=SD(Xi)
		nS =  Input size of pS
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
//OCMATH_API int ocmath_Normalize_X(const LROptions* psLROptions, const double* pX, const double nOSizeN, const double nVSizeM, double* pNormX, double* pS, uint nS);
OCMATH_API int ocmath_normalize_x(const LROptions* psLROptions, const double* pX, const double nOSizeN, const double nVSizeM, double* pNormX, double* pS, uint nS);

/**$
	Remarks:
		Function to apply necessary corrections to the obtained coefficients estimates
		as well as to the variance-covariance matrix to get the solution of  the 
		original problem and correct statistics in MR.
	Parameters:
		psLROptions=Input pointer to struct for linear regression options 
		psRegStats=Input pointer to struct containing Regression statistics
		psFitParameter=Input pointer to structs to information of each fitting parameter
		nFitSize=Input the size of psFitParameter, should be nVSizeM + 1
		pCov = Input pointer to covariance matrix of estimate
		nCovCol = Input column size of Covariance and Correlation matrix, which should be nVSizeM + 1 if intercept exists
		nCovRow = Input row size of Covariance and Correlation matrix, which should be nVSizeM + 1 if intercept exists
		pS=Input pointer to vector (1/S1, ..., 1/Sp), Si=SD(Xi)
		nS =  Input size of pS
		psCorrFitParam=Output pointer to corrected information of each fitting parameter
		pCorrectedCov=Output pointer to corrected variance-covariance matrix.
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
		
*/
///Kevin 11/29/05 CHANGE_OCMATH_FUNCTION_TO_LOWER_CASE
//OCMATH_API int ocmath_MR_Results_Corrected(const LROptions* psLROptions, const RegStats* psRegStats, const FitParameter* psFitParameter, const UINT nFitSize, const double* pCov, const uint nCovCol, const uint nCovRow, const double* pS, uint nS, 
//								FitParameter* psCorrFitParam, double* pCorrectedCov);
OCMATH_API int ocmath_MR_results_corrected(const LROptions* psLROptions, const RegStats* psRegStats, const FitParameter* psFitParameter, const UINT nFitSize, const double* pCov, const uint nCovCol, const uint nCovRow, const double* pS, uint nS, 
								FitParameter* psCorrFitParam, double* pCorrectedCov);

// Category last updated by Echo on 6/2/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_partial_reg_plots_(global_function)
*/
OCMATH_API int ocmath_partial_reg_plots(const double *pX, UINT nOSizeN, UINT nVSizeM, const double *pY, const LROptions* psLROptions, double *pPlotMat, uint nMPlotMat);

// Category last updated by Echo on 6/2/2008
/**# >Fitting
	Remarks:
		Function to correct variable for regression plots
	Parameters:
		pX=Input matrix containing data points of the independent variables
		pY=Input vector containing data points of dependent variable, size of pY = n
		pWT=Input vector containing weight of the data, all date in pWT should not less than zero
		nSize=Input the size of the pX, pY and [WT
		sLROptions=Input pointer to struct for linear regression options. Please note that the pointer structure should not be NULL.
		psInternal=Ouput pointer to struct containing Sxx, Sxy,Syy ect
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_reg_plots(const double* pX, const double* pY, const double* pWT, int nSize, const LROptions* psLROptions, RegCalcInternal* psInternal);

//Echo 08/15/05 QA70-6327 ADD_AIC


// Category last updated by Echo on 6/2/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_AIC_(global_function)
*/
OCMATH_API double ocmath_AIC(const int nSize, const int nParam, const double dSSE, int* iFault = NULL);

//Echo 08/18/05 QA70-7432 ADD_DIAGNOSTIC_RESIDUALS_COMPUTATION
// Category last updated by Echo on 6/2/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_diagnostic_residuals_(global_function)
*/
OCMATH_API int ocmath_diagnostic_residuals(const int nSize, const int nParam, const double dSSE, int nResid, 
										   const double* pResid, const double* pX, double* pStadRes, double* pStudRes, double* pStudDelRes, double* pCook, double* pAtkinson, double* pH=NULL);

// Category last updated by Echo on 6/2/2008
/**$
	Remarks:
		This function compute the confidence ellipse for sample data by calling function 
	    mean_ellipse() or prediction_ellipse() to calculate the points on the ellipse 
	    according to the type.

	Keywords: 
		Prediction ellipse, Mean ellipse

	Example:
		void ocmath_ellipse_ex()
		{	
			const vector vX = {-5.50031, -5.50031, -6, -6, -6.50031, -6.50031};
			const vector vY = {1.51825, 1.82343, 1.14994, 1.06593, 0.69423, 0.54704};
			const vector vW = {0.75913, 0.91172, 0.57497, 0.53297, 0.34712, 0.27352};
			//const vector vW = {1, 1, 1, 1, 1, 1};
			
			const uint nEllipseSize=133;
			vector vEllipseX(nEllipseSize);
			vector vEllipseY(nEllipseSize);
			
			const double alpha = 0.05;
			int nType=0;
			int nRet = ocmath_ellipse(vX, vY, vW, vX.GetSize(), alpha, nEllipseSize, vEllipseX, vEllipseY, nType);		
		}
	Parameters:
		pX=[Input] matrix containing data points of the independent variables size of pX is nSize
		pY=[Input] vector containing data points of dependent variable, size of pY is nSize
		pWT=[Input] vector containing weight of the data, all date in pWT should not less than zero, size of pWeight is nSize
		nSize=[Input] size of Data, the number of observations, n. n>=2
		alpha=[Input] the significance level
		nEllipseSize=[input] size of ellipse points.
		pEllipseX=[output] pointer to calculated x value of the confidence ellipse
		pEllipseY=[output] pointer to calculated y value of the confidence ellipse
		nType=[Input] flag to indicate which confidence ellipse to calculate.
				0: Prediction ellipse
				1: Mean ellipse
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_ellipse(const double* pX, const double* pY, const double* pWT, const uint nSize, const double alpha, const uint nEllipseSize, double* pEllipseX, double* pEllipseY, int nType = 0);

///Echo 5/18/06 QA70-6027 v8.0411 ADD_NLSF_ANOVA
/**#
	Remarks:
		The function is to compute anova table in NLSF
	Example:
	Parameters:
		nSize=[Input] size of Data, the number of observations, n. n>=2
		pX=[Input] point to data points of the independent variables, size of pX is nSize
		pY=[Input] pointer to data points of dependent variable, size of pY is nSize
		nParam = [input] the number of parameters fit by the regression.
		dSSE = [input] the sum of square of residuals
		psRegANOVA=[output] pointer to struct containing ANOVA statistics.
		pWT=[Input] vector containing weight of the data, all date in pWT should not less than zero, size of pWeight is nSize
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_nlsf_anova(const uint nSize, const double* pX, const double* pY, 
								 const int nParam, const double dSSE, RegANOVA* psRegANOVA, const double* pWT= NULL, RegANOVARow* psCorrTotal = NULL);

/////////////////////////////////////////////////////////////////////////////////
//
//				t-Test Functions									
//
/////////////////////////////////////////////////////////////////////////////////
// Comments last updated by Army on 07/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_one_sample_t_test_(global_function)
*/
OCMATH_API int ocmath_one_sample_t_test(const double* pData, UINT nSize, const HypotTestOptions* opt,
	 tTestMean1SampleResults* res);

// Comments last updated by Army on 07/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_confidence_levels_for_mean_(global_function)
*/
OCMATH_API int ocmath_confidence_levels_for_mean(const double* pLevels, UINT nLevels, const tTestMean1SampleResults* tTestRes, 
												 double* pLCLs, double* pUCLs);
///Echo 7/5/06 MAKE_SEPERATED_VARIANCE_TEST
///Chi Square test is redesigned as an independent fucntion, so we need to recreate related LLVC 
///**$
		//Function to perform a Chi-Square Test for equal variance.
	//Parameters:
		//opt=Input structure containing Chi-Square Test options
		//tTestRes=Input structure containing t-Test results output from ocmath_one_sample_t_test
		//res=Output structure containing Chi-Square Test Results
	//Return:
		//Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
	//Reference:
		//1> Engineering Statistics Handbook
		//http://www.itl.nist.gov/div898/handbook/eda/section3/eda358.htm
//*/
//OCMATH_API int ocmath_chi_square_test(const HypotTestOptions* opt, const tTestMean1SampleResults* tTestRes,
	 //ChiSqVar1SampleResults* res);
	 
// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_chi_square_test_(global_function)
*/
OCMATH_API int ocmath_chi_square_test(UINT nSize, const double* pData, const HypotTestOptions* opt,
									  tTestResults* pChiSqRes);
///end MAKE_SEPERATED_VARIANCE_TEST

///Echo 7/5/06 MAKE_SEPERATED_VARIANCE_TEST
///Chi Square test is redesigned as an independent fucntion, so we need to recreate related LLVC 
///**$
		//Function to compute confidece levels for a variance.
	//Parameters:
		//pLevels=Input pointer to confidence levels, e.g. {0.9, 0.95, 0.99}
		//nLevelSize=Input number of levels in pLevels. 
		//tTestRes=Input structure containing t-Test results from ocmath_one_sample_t_test
		//pLCLs=Output pointers to Lower Confidence Limits for variance
		//pUCLs=Output pointers to Upper Confidence Limits for variance
	//Return:
		//Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
//*/
//OCMATH_API int ocmath_confidence_levels_for_variance(const double* pLevels, UINT nLevelSize, const tTestMean1SampleResults* tTestRes,
													 //double* pLCLs, double* pUCLs);

// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_confidence_levels_for_variance_(global_function)
*/
OCMATH_API int ocmath_confidence_levels_for_variance(UINT nLevels, const double* pLevels, const double dSD, const double dDOF,
													 double* pLCLs, double* pUCLs);
///end MAKE_SEPERATED_VARIANCE_TEST
													 
/**#
		Function to compute actual or hypothetical powers for a t-Test using result of ocmath_one_sample_t_test.
	Parameters:
		dSigLevel=Input significance level for power computations
		iTailType=Compute powers for a two-tailed, upper tailed, or lower tailed test. iTailType could be TAILED_TEST_TWO, TAILED_TEST_UPPER, or TAILED_TEST_LOWER.
		pSampleSizes=Input pointer to actual and hypothetical sample sizes
		nSizes=Input number of sample size in pSampleSizes. 
		tTestRes=Input structure containing t-Test results output from ocmath_one_sample_t_test
		pPowers=Output pointers to powers
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/

OCMATH_API int ocmath_tTest_powers(const double dSigLevel, const int iTailType, const double* pSampleSizes, const UINT nSizes,
	 tTestMean1SampleResults* tTestRes, double* pPowers);                                       



// Category last updated by Echo on 6/2/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:Ocmath_two_sample_t_test_(global_function)
*/
OCMATH_API int ocmath_two_sample_t_test(const double* pData1, UINT nSize1, 
													const double* pData2, UINT nSize2,
													const HypotTestOptions* opt,  
													tTestMean2SampleResults* res, 
													tTestResults* tResUneqVar = NULL);

// Comments last updated by Army on 07/30/2009
/**$ >Statistics>Hypothesis Testing
	Remarks:
		Function to compute confidece levels for the mean of pData1 minus the mean of pData2, assuming equal variance.
	Example1:
		void ocmath_two_sample_confidence_levels_for_mean_equal_var_ex1()
		{
		 	vector vData1 = { 1.7, 2.1, 3.9, 7.2, 8.6, 8.5, 7.3, 5.1, 2.8, 1.8, 1.7 };
		  	vector vData2 = { 3.2, 3.9, 4.9, 5.3, 5.5, 6.2, 6.5, 6.9, 7.5, 8.3, 9.4 };  
		   	HypotTestOptions HTO;
			tTestMean2SampleResults tRes;
			double mean = 0.0;
			int tail = 1;
			HTO.HypotValue = mean;
			HTO.TailType=tail;
			//get t-Test results from ocmath_two_sample_t_test
			int nRet = ocmath_two_sample_t_test(vData1, vData1.GetSize(), vData2, vData2.GetSize(), &HTO, &tRes);
			
			vector vLevels = {0.9, 0.95, 0.99};
			UINT nLevels = vLevels.GetSize();
			vector vLCLs, vUCLs;
			vLCLs.SetSize(nLevels);
			vUCLs.SetSize(nLevels);
			
			nRet = ocmath_two_sample_confidence_levels_for_mean_equal_var(vLevels, nLevels, &tRes, vLCLs, vUCLs);
			out_int("nRet=", nRet); //nRet = 0;
			int ii;
			
			//print out Lower Confidence Limits for mean
			printf("vLCLs = {");
			for(ii=0; ii<vLCLs.GetSize(); ii++)
			{
				printf("%f\t", vLCLs[ii]);
			}
			printf("}\n");
			
			//print out Upper Confidence Limits for mean
			printf("vUCLs = {");
			for(ii=0; ii<vUCLs.GetSize(); ii++)
			{
				printf("%f\t", vUCLs[ii]);
			}
			printf("}\n");	
		}		
	Parameters:
		pLevels=[Input] vector containing confidence levels, e.g. {0.9, 0.95, 0.99}		
		nLevels=[Input] number of levels in pLevels. 
		tTestRes=[Input] structure containing t-Test results from ocmath_two_sample_t_test
		pLCLs=[Output] pointers to Lower Confidence Limits for mean
		pUCLs=[Output] pointers to Upper Confidence Limits for mean
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
	SeeAlso:
		ocmath_two_sample_confidence_levels_for_mean_unequal_var, ocmath_two_sample_confidence_levels_for_mean_pair
*/
OCMATH_API int ocmath_two_sample_confidence_levels_for_mean_equal_var(const double *pLevels, UINT nLevels, const tTestMean2SampleResults* ptTestRes, 
																	  double *pLCLs, double *pUCLs);

/**$
	Remarks:
		Function to compute confidece levels for the mean of pData1 minus the mean of pData2, assuming unequal variance.
	Parameters:
		pLevels=Input vector containing confidence levels, e.g. {0.9, 0.95, 0.99}		
		nLevels=Input number of levels in pLevels. 
		tTestRes=Input structure containing t-Test results from ocmath_two_sample_t_test
		pLCLs=Output pointers to Lower Confidence Limits for mean
		pUCLs=Output pointers to Upper Confidence Limits for mean
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_two_sample_confidence_levels_for_mean_unequal_var(const double *pLevels, UINT nLevels, const tTestMean2SampleResults* ptTestRes, 
																	  double *pLCLs, double *pUCLs);

/**#
	Remarks:
		Function to perform a Chi-Square Test for equal variance. assuming equal variance
	Parameters:
		opt=Input structure containing Chi-Square Test options
		tTestRes=Input structure containing t-Test results output from ocmath_two_sample_t_test
		res=Output structure containing Chi-Square Test Results
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
	Reference:
		1> Engineering Statistics Handbook
		http://www.itl.nist.gov/div898/handbook/eda/section3/eda358.htm
*/	
OCMATH_API int ocmath_two_sample_chi_square_test(const HypotTestOptions* opt, 
												 const tTestMean2SampleResults* tTestRes,	 
												 ChiSqVar2SampleResults* res);
///Echo 7/5/06 MAKE_SEPERATED_VARIANCE_TEST
///F test is redesigned as an independent fucntion, so we need to recreate related LLVC 
///**$
		//Function to perform a F Test for equal variance.
	//Parameters:
		//opt=Input structure containing Chi-Square Test options
		//tTestRes=Input structure containing t-Test results output from ocmath_two_sample_t_test
		//res=Output structure containing Chi-Square Test Results
	//Return:
		//Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
	//Reference: 
		//1> Engineering Statistics Handbook
		//http://www.itl.nist.gov/div898/handbook/eda/section3/eda359.htm
//*/
//OCMATH_API int ocmath_f_test(const HypotTestOptions* opt, 
							 //const tTestMean2SampleResults* tTestRes, FVarResults* res);		
					 
// Category last updated by Echo on 6/2/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_f_test_(global_function)
*/
OCMATH_API int ocmath_f_test(UINT nSize1, const double* pData1,
							 UINT nSize2, const double* pData2, 
							 const HypotTestOptions* opt,  
							 FVarResults* res);
///end MAKE_SEPERATED_VARIANCE_TEST
							 
///Echo 7/5/06 MAKE_SEPERATED_VARIANCE_TEST
///F test is redesigned as an independent fucntion, so we need to recreate related LLVC 
///**
		//Function to compute confidece levels for a variance, based on F test for variance.
	//Parameters:
		//pLevels = Input double array containing confidence levels, e.g. {0.9, 0.95, 0.99}
		//nLevels = Input the size of confidence levels
		//tTestRes = Input structure containing t-Test results from ocmath_two_sample_t_test
		//pLCLs = Output double array containing Lower Confidence Limits for variance
		//pUCLs = Output double array containing Upper Confidence Limits for variance
	//Return:
		//Returns 0 on successful exit and error ID on failure.
//*/	
//OCMATH_API int ocmath_two_sample_confidence_levels_for_variance(const double* pLevels, UINT nLevels, 
																//const tTestMean2SampleResults* tTestRes,
																//double* pLCLs, double* pUCLs);
/**$
	Remarks:
		Function to compute confidece levels for a variance, based on F test for variance.
	Parameters:
		nLevels=[input] the size of confidence levels
		pLevels=[input] pointer to confidence levels, e.g. {0.9, 0.95, 0.99}
		pSD=[input] pointer to SD value of the 2 input data used in variance test
		pN=[input]pointer to Size of the 2 input data used in variance test
		pLCLs=[output] pointer to Lower Confidence Limits for variance
		pUCLs=[output] pointer to Upper Confidence Limits for variance
	Return:
		Returns 0 on successful exit and error ID on failure.
*/	
OCMATH_API int ocmath_two_sample_confidence_levels_for_variance(UINT nLevels, const double* pLevels, 
																const double* pSD, const int* pN,
																double* pLCLs, double* pUCLs);
///end MAKE_SEPERATED_VARIANCE_TEST

// Comments last updated by Army on 07/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_tTest_powers_(global_function)
*/
OCMATH_API int ocmath_two_sample_tTest_powers(const double dSigLevel, const HypotTestOptions* opt, const double* pSampleSizes, UINT nSizes, 
	 tTestMean2SampleResults* tTestRes, double* pPowers); 

// Category last updated by Echo on 6/2/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_t_test_pair_(global_function)
*/
OCMATH_API int ocmath_two_sample_t_test_pair(const double *pData1, UINT nSize1, const double *pData2, UINT nSize2,
											 const HypotTestOptions *opt, 
											 tTestMean2SampleResults* res);
// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_confidence_levels_for_mean_pair_(global_function)
*/
OCMATH_API int ocmath_two_sample_confidence_levels_for_mean_pair(const double *vLevels, int nLevelSize,
																 const tTestMean2SampleResults *tTestRes,
																 const HypotTestOptions *opt, 
																 double *vLCLs, double *vUCLs);

// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_tTest_powers_pair_(global_function)
*/
OCMATH_API int ocmath_two_sample_tTest_powers_pair(const double dSigLevel, const HypotTestOptions *opt, 
												  const double *vSampleSizes,  UINT nSizes,
												  tTestMean2SampleResults *tTestRes, 
												  double *vPowers);    

// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_row_ttest2_(global_function)
*/
OCMATH_API int ocmath_row_ttest2(UINT nRows, UINT nCols, const double* pMat1, const double* pMat2, const double dDiffMean, const int nTail,
								 double* pStat=NULL, double* pDF=NULL, double* pProb=NULL);
/////////////////////////////////////////////////////////////////////////////////
//
//				Normality Testing Functions									
//
/////////////////////////////////////////////////////////////////////////////////
//Comments last updated by Iris 2008-7-21											  
/**$ >Statistics>Normality Tests
	Remarks:
		Function to preform Shapiro-Wilk test for normality	with Algorithm AS 181
	Example:
		void ocmath_shapiro_wilk_test_AS181_ex1()
		{
		   int nRet;
		   float X[] = {0.139,0.157,0.175,0.256,0.344,0.413,0.503,0.577,0.614,
				   0.655,0.954,1.392,1.577,1.648,1.690,1.994,2.174,2.206,
				   3.245,3.510,3.571,4.354,4.980,6.084,8.351};
		   int N = 25;
		   float W, PW;
		   int nErr = 10;
		   nRet = ocmath_shapiro_wilk_test_AS181(X, N, &W, &PW, &nErr);
		} 
	Parameters:
		pX=Input pointer to ordered sample values
		N=Input value indicates sample size
		W=Output W Statistic
		PW=Output significance level of W
		nErr=Output fault indicator, equal to 
			2	if N > 2000
			1	if N <= 2
			0	otherwise
	Return:
		Returns STATS_NO_ERROR on successful exit.
	Reference:
		1> Royston J P (1982a) Algorithm AS181: The W Test for Normality Appl. Statist. 31 176-180
*/
OCMATH_API	int	ocmath_shapiro_wilk_test_AS181(float* pX, UINT N, float* W, float* PW, int* nErr);

// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_shapiro_wilk_test_R94_(global_function)
*/
OCMATH_API	int	ocmath_shapiro_wilk_test_R94(double* pX, UINT N, double* W, double* PW, int* nErr);
//Comments last updated by Jake on 2007-7-16
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_shapiro_wilk_test_(global_function)
*/
OCMATH_API int ocmath_shapiro_wilk_test(UINT nSize, const double* pX, NormTestResults* SWRes, const int iOption = SHAPIRO_WILK_R94); 
//Comments last updated by Jake on 2007-7-16
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_kolmogorov_smirnov_test_(global_function)
*/
OCMATH_API int ocmath_kolmogorov_smirnov_test(UINT nSize, const double* pData, NormTestResults* KSRes, const int nParatype = PARA_ESTIMATED, UINT nParSize = 2, double* pPar = NULL );

/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_lilliefors_test_(global_function)
*/
OCMATH_API int ocmath_lilliefors_test(const double* pData, UINT nSize, NormTestResults* LFRes);
/////////////////////////////////////////////////////////////////////////////////
//
//				One Way ANOVA Functions									
//
/////////////////////////////////////////////////////////////////////////////////
// Category last updated by Echo on 6/2/2008
/**# >Statistics>ANOVA
	Remarks:
		Function to compute orthogonal polynomial or dummy variables for a factor or classfication variable.
	Parameters:
		nDummyType=Input value indicatesthe type of dummy variable to be computed
				DUMMY_FIRSTLEVEL:	the contrasts relative to the Firstlevel are computed.
				DUMMY_LASTLEVEL:	the contrasts relative to the Last level are computed.
				DUMMY_ALLLEVELS:	A complete set of dummy variables is computed.
		nObs=Input integer specified the number of observations for which the dummy variables are to be computed. nObs>= nLevels.
		nLevels=Input integer specified the number of levels of the factor. nLevels>=2
		pFactor=Input pointers to the nObs values of the factor. 1<=pFactor[i-1]<=nLevels, i=1,...,nObs
		pX=Output pointers to the dummy variables obtained
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API	int ocmath_dummy_vars(const int nDummyType, int nObs, int* pFactor, double* pX);

// Comments last updated by Stacy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_anova_one_way_(global_function)
*/
OCMATH_API int ocmath_anova_one_way(const			double *pData, uint nSize,
									int				iLevels,
									const			int *pIndex,
									ANOVADescStats* DescStats, uint nSizeDescStat, 
									ANOVAStats*		TotalStats, 
									RegANOVA*		ANOVATable);

// Category last updated by Echo on 6/2/2008
/**# >Statistics>ANOVA
	Remarks:
		Function to compute One-Way ANOVA Mean Comparisons. Computes simultaneous confidence intervals for the differences 
		between means. 
	Parameters:
		pMean=Input pointer to Mean of each group
		nSizeMean=Input size of pointer pMean, which should not be less than nGroupSize
		pNPTS=Input pointer to size of each group
		nSizeNPTs=Input size of pointer pNPTs, which should not be less than nGroupSize
		dMSE=Input Mean Square for Error term of the model
		DOF=Input Degree of Freedom for Error term of the model
		dAlpha=Input number indicates the significant level of the model
		nGroupSize=Input size indicates group number.
		pIndexComparison=Output pointer to order of means comparison
		nSizeComparison=Input size of pointer pIndexComparison, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pMeanDiffs=Output pointer to difference of means of two Samples
		nSizeMeanDiff=Input size of pointer pMeanDiffs, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pLCLs=Output pointer to lower confidence limits for difference of means
		nSizeLCL=Input size of pointer pLCLs, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pUCLs=Output pointer to upper confidence limits for difference of means
		nSizeUCL=Input size of pointer pUCLs, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pSe=Output pointer to Standard Errors of difference between means
		nSizeSe=Input size of pointer pSe, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pStat=Output pointer to Statistic used to test difference between means
		nSizeStat=Input size of pointer pStat, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pProb=Output pointer to Probability of the test for difference between means
		nSizeProb=Input size of pointer pProb, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pSig=Output pointer to indicator whether the difference between means is significant or not.
				pSig[i] =1:		the difference is significant
				pSig[i] =0:		the difference is NOT significant	i=0, 1, ..., nSizeSig-1
		nSizeSig=Input size of pointer pSig, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		pAlpha=Output pointer to significance level that depends upon the test
		nSizeAlpha=Input size of pointer pAlpha, which should not be less than (nGroupSize*(nGroupSize-1)/2)
		nIntervalType=Input interger that indicates which method to be used
						ANOVA_BONFERRON = 1:	the Bonferroni method is used
						ANOVA_TUKEY = 2:		the Tukey-Kramer method is used
						ANOVA_SCHEFFE = 3:		the Scheffe method is used
						ANOVA_SIDAK = 4:		the Dunn-Sidak method is used
						ANOVA_FISHER = 5:		the Fisher's LSD method is used
						ANOVA_BONHOLM = 6:		the Bonferroni-Holm method is used
						ANOVA_SIDAKHOLM = 7:	the Sidak-Holm method is used
						ANOVA_DUNNETT = 8:		the Dunnett method is used
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/

/// Max 03/16/05 REWRITE_ONEWAYANOVA_MEAN_COMPARISON
OCMATH_API int ocmath_anova_mean_comparison(const	double *pMean,	uint nSizeMean,
											const	int *pNPTS, uint nSizeNPTs,
											const	double dMSE, 
											const	int nDOF,
											const	double dAlpha,
											const	int nGroupSize, 
											int		*pIndexComparison, uint nSizeComparison,
											double	*pMeanDiffs, uint nSizeMeanDiff,
											double	*pLCLs, uint nSizeLCL,
											double	*pUCLs, uint nSizeUCL,
											double	*pSe, uint nSizeSe,
											double	*pStat, uint nSizeStat,
											double	*pProb, uint nSizeProb,
											long	*pSig, uint nSizeSig,
											double  *pAlpha, uint nSizeAlpha,
											int		nIntervalType
											);
/*
OCMATH_API int ocmath_anova_mean_comparison(const	 double *pMean,	uint nSizeMean,
											const	 int *pNPTS, uint nSizeNPTs,
											const	 double dMSE, 
											const	 int nDOF,
											const	 double dAlpha,
											const	 int nGroupSize,
											double	 *pMeanDiffs, uint nSizeMeanDiff,
											double	 *pLCIs, uint nSizeLCI,
											double	 *pUCIs, uint nSizeUCI,
											double	 *pSe, uint nSizeSe,
											double	 *pSig, uint nSizeSig,
											int		 nIntervalType
											);
*/
/*
OCMATH_API int ocmath_anova_mean_comparison(const	 double *vMean,	uint nSizeMean,
											const	 int *vNPTS, uint nSizeNPTs,
											const	 double dMSE, 
											const	 int DOF,
											const	 double alpha,
											const	 int GroupSize,
											double	 *vMeanDiffs, uint nSizeMeanDiff,
											double	 *vLCIs, uint nSizeLCI,
											double	 *vUCIs, uint nSizeUCI,
											double	 *dSe, uint nSizeSe,
											double	 *vSig, uint nSizeSig,
											int		 nIntervalType = 1
											);
*/
/// END REWRITE_ONEWAYANOVA_MEAN_COMPARISON


// Category last updated by Echo on 6/2/2008
/**# >Statistics>ANOVA
		Function to test for equal variance of One-Way ANOVA. 
	Parameters:
		pData=Input pointer to data points
		nSize=Input size of pointer pData
		iLevels=Input number indicates the number of levels
		index=Input pointer to the number of each group, the size of index should be iLevels
		DescStats=Output reference to struct containing descriptive statistics
		nSizeDescStat=Input size (number of structs) of DescStats, which should be less than iLevel.
		ANOVATable=Output reference to struct containing results of test for equal variance
		nStasticType=Input interger that indicates which statistic to be used.
			ANOVA_LEVENE = 1:	the Levene stastic | | is used
			ANOVA_LEVENESQ = 2	the Levene Squared stastic ()^2 is used
			ANOVA_BROWN = 3		the Brown=Forsythe stastic is used
			ANOVA_CHISQ = 4		the Chi-Square stastic is used	
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_anova_equal_variance_test(const			double *pData, uint nSize,
												const int				iLevels,
												const			int *index,
												ANOVADescStats	*DescStats,uint nSizeDescStats, 
												RegANOVA		*ANOVATable,
												int				nStasticType = 0);

/**#
		Function to compute actual or hypothetical powers for one way ANOVA. 
	Parameters:
		dSigLevel=Significance level for power computations
		pSampleSizes=Actual and hypothetical sample sizes
		nSize=Input number indicates the size of pSampleSizes
		psANOVATable=Input structure containing one way ANOVA results output from stats_anova_one_way
		pPowers=Output vector containing powers
	Return:
		Returns STATS_NO_ERROR on successful exit and a non-zero STATS error code on failure.
*/
OCMATH_API int ocmath_anova_powers(const double dSigLevel, const double* pSampleSizes, const UINT nSizes,                       
	 RegANOVA* psANOVATable, double* pPowers);




/////////////////////////////////////////////////////////////////////////////////
//
//				Independent Sample Sizes and Powers Functions									
//
/////////////////////////////////////////////////////////////////////////////////
//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_tTest_powers1_(global_function)
*/


OCMATH_API int ocmath_tTest_powers1(const double dSigLevel, int iTailType, const double* pSampleSizes,  UINT nSizes,
	 PowerOpts* tPowerOpts, double* pPowers);                                       

//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_tTest_samplesize_(global_function)
*/
OCMATH_API int ocmath_tTest_samplesize(const double dSigLevel,  int iTailType,
									   const double* pPowers,  UINT nSizes,
	 								   PowerOpts* tPowerOpts, double* pSampleSizes, 
									   double* pLowestPower);


//Comments last updated by Stacy on 7/29/2009									   
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_tTest_powers1_(global_function)
*/
OCMATH_API int ocmath_two_sample_tTest_powers1(const double dSigLevel, HypotTestOptions* opt, 
											   const double* pSampleSizes, UINT nSizes, 
											   PowerOpts* tPowerOpts, double* pPowers); 

//Comments last updated by Stacy on 7/29/2009											   
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_tTest_samplesize_(global_function)
*/
OCMATH_API int ocmath_two_sample_tTest_samplesize(const double dSigLevel, HypotTestOptions* opt, 
												  const double* pPowers,  UINT nSizes, 
												  PowerOpts* tPowerOpts, double* pSampleSizes, 
												  double* pLowestPower);


//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_tTest_powers_pair1_(global_function)
*/
OCMATH_API int ocmath_two_sample_tTest_powers_pair1(const double dSigLevel,  HypotTestOptions *opt, 
												    const double *pSampleSizes,  UINT nSizes,
												    PowerOpts* tPowerOpts, double *pPowers);                             
                        
//Comments last updated by Stacy on 7/29/2009 
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_two_sample_tTest_samplesize_pair_(global_function)
*/

OCMATH_API int ocmath_two_sample_tTest_samplesize_pair(const double dSigLevel, 
													   HypotTestOptions *opt, 
													   const double *pPowers, UINT nSizes,
													   PowerOpts* tPowerOpts, double*pSampleSizes, 
													   double* pLowestPower);

//Comments last updated by Stacy on 7/29/2009													   
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_anova_powers1_(global_function)
*/
OCMATH_API int ocmath_anova_powers1(const double dSigLevel, const double* pSampleSizes, const UINT nSize,
	ANOVAPowerOpts* tPowerOpts, double* pPowers);

//Comments last updated by Stacy on 7/29/2009	
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_anova_samplesize_(global_function)
*/
OCMATH_API int ocmath_anova_samplesize(const double dSigLevel, const double* pPowers, const UINT nSize,
	ANOVAPowerOpts* tPowerOpts, double* pSampleSizes);                                       




/////////////////////////////////////////////////////////////////////////////////
//
//				Two Way ANOVA Functions									
//
/////////////////////////////////////////////////////////////////////////////////
// Category last updated by Echo on 6/2/2008
/**# >Statistics>ANOVA
		Two-Way ANOVA function to compute the Two-Way ANOVA F table. The Origin Two-Way ANOVA dialog
		box uses a linear regression approach in order to support unequal cell sizes (However, empty
		cells are not supported). The reference for Origin's two-way analysis of variance is Applied
		Linear Statistical Models, Neter J., Kutner M., Nachtsheim C., and Wasserman W. (1996), The
		McGraw-Hill Companies, Inc., Boston, MA. See Section 22.2 for a discussion of how to use dummy
		variables for testing both factor main effects and interaction effects. The Origin Two-Way ANOVA
		dialog box also makes use of the LLVC functions ocmath_dummy_vars to create the necessary
		design matrices and ocmath_multiple_linear_regression to perform the linear regressions of the
		design matrices. The results of the linear regressions are then used to construct the two-way
		ANOVA table.
	Example:
		See the main Two-Way ANOVA function stats_anova_two_way_compute_anova_table above for a sample call.
	Parameters:
		iInteractions=Flag indicating whether (1) or not (0) interaction effects are to be determined
		vFACTOR_A=Vector containing integerized level indices (1 based) for Factor A
		iLevelsA=The number of Factor A levels
		vFACTOR_B=Vector containing integerized level indices (1 based) for Factor B
		iLevelsB=The number of Factor D levels
		vDEP_VAR=Vector containing dependent variable data values
		nPts=Number of data values
		ADescStats=Output structure pointer to descriptive statistics results of FactorA
		BDescStats=Output structure pointer descriptive statistics results of FactorB
		ToDescStats=Output structure containing descriptive statistics results of whole data.
		ABDescStats=Output structure containing descriptive statistics results of FactorA*FactorB		
		arANOVA2_Table=A five(if no interaction) or six(if intercaction) element array of 
					   an RegANOVA structure holding all computed F Table values, 
					   one element for each row in the ANOVA F table (A, B, A * B, Model, Error and Corrected Total).
	Return:
		Returns a five(if no interaction) or six(if intercaction) element array of an RegANOVA structure 
		holding all computed F Table values	which has one element for each row in the ANOVA F table
		(A, B, A * B(if interaction), Model, Error and Corrected Total) and returns element array of 
		an ANOVA2DescStats structure holding descriptive stastics for each group of A, group of B and group of A*B. 
		Also returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/
OCMATH_API int ocmath_stats_anova_two_way_compute_anova_table( int iInteractions, 
																const int *vFACTOR_A, int iLevelsA,
																const int *vFACTOR_B, int iLevelsB,
																const double *vDEP_VAR, 
																int nPts,
																ANOVA2DescStats *ADescStats, 
																ANOVA2DescStats *BDescStats,
																ANOVA2DescStats	*ToDescStats, 
																ANOVA2DescStats *ABDescStats,
																ANOVA2Table		*arANOVA2_Table);

/**$
*/
OCMATH_API int	ocmath_anova2_count_values_per_cell(UINT nSize, const int* pFactorA, const int* pFactorB);

// Category last updated by Echo on 6/2/2008
/**# >Statistics>ANOVA
		Two-Way ANOVA function to perform a Means Comparison analysis for a single factor of the
		Two-Way ANOVA dialog box.
	Example:
	Parameters:
		pFactor=Input pointer to Factor 'A' or Factor 'B'
		nLevels=Input number indicates group number
		pDEP_VAR=Input pointer to the dependent variable data 
		         whose levels are indicated by the paired pointer pFACTOR
		nPts=Input number of data points		
		dDFE=Input Degrees of Freedom for the Error term of the model
		dMSE=Input Mean Square for the Error term of the model
		dSigLevel=Input significance Level of the model
		pIndexComparison=Output pointer to order of means comparison
		nSizeComparison=Input size of pointer pIndexComparison, which should not be less than nLevels*(nLevels-1)/2
		pMeanDiffs=Output pointer to mean difference of each group
		nSizeMeanDiff=Input size of pointer pMeanDiffs, it should not be less than nLevels*(nLevels-1)/2
		pLCLs=Output pointer to lower confidence limit of each group
		nSizeLCL=Input size of pointer pLCLs, it should not be less than nLevels*(nLevels-1)/2
		pUCLs=Output pointer to upper confidence limit of each group
		nSizeUCLs=Input size of pointer pUCIs, it should not be less than nLevels*(nLevels-1)/2
		pSe=Output pointer to Standard Errors of difference between means
		nSizeSe=Input size of pointer pSe, it should not be less than nLevels*(nLevels-1)/2
		pStat=Output pointer to Statistic used to test difference between means
		nSizeStat=Input size of pointer pStat, which should not be less than nLevels*(nLevels-1)/2
		pProb=Output pointer to Probability of the test for difference between means
		nSizeProb=Input size of pointer pProb, which should not be less than nLevels*(nLevels-1)/2
		pSig=Output pointer to indicator whether the difference between means is significant or not.
				pSig[i] =1:		the difference is significant
				pSig[i] =0:		the difference is NOT significant	i=0, 1, ..., nSizeSig-1
		nSizeSig=Input size of pointer pSig, which should not be less than nLevels*(nLevels-1)/2
		pAlpha=Output pointer to significance level that depends upon the test method
		nSizeAlpha=Input size of pointer pAlpha, which should not be less than nLevels*(nLevels-1)/2
		iTestType=Input interger that indicates which method to be used
						ANOVA_BONFERRON = 1:	the Bonferroni method is used
						ANOVA_TUKEY = 2:		the Tukey-Kramer method is used
						ANOVA_SCHEFFE = 3:		the Scheffe method is used
						ANOVA_SIDAK = 4:		the Dunn-Sidak method is used
						ANOVA_FISHER = 5:		the Fisher's LSD method is used
						ANOVA_BONHOLM = 6:		the Bonferroni-Holm method is used
						ANOVA_SIDAKHOLM = 7:	the Sidak-Holm method is used
						ANOVA_DUNNETT = 8:		the Dunnett method is used
	Return:
		Computes Two-Way ANOVA Means Comparison results. Also returns
		STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/
/// Max 03/16/05 REWRITE_TWOWAYANOVA_MEAN_COMPARISON
OCMATH_API int osANOVA2Way_Means_Comparison( const int		*pFACTOR,
											 const int		nLevels,
											 const double	*pDEP_VAR,
											 const int		nPts, 
											 const double	dDFE, 
											 const double	dMSE, 
											 const double	dSigLevel,
											 int		*pIndexComparison, uint nSizeComparison,	//output
											 double		*pMeanDiffs, uint nSizeMeanDiff,	
											 double		*pLCLs, uint nSizeLCL,
											 double		*pUCLs, uint nSizeUCL,
											 double		*pSe, uint nSizeSe,
											 double		*pStat, uint nSizeStat,
											 double		*pProb, uint nSizeProb,
											 long		*pSig, uint nSizeSig,
											 double		*pAlpha, uint nSizeAlpha,
											 int		iTestType);
/*
OCMATH_API int osANOVA2Way_Means_Comparison( const int *vFACTOR,
											 const int nLevels,
											 const double *vDEP_VAR,
											 int nPts, 
											 double dDFE, 
											 double dMSE, 
											 double dSigLevel,
											 double	 *vMeanDiffs, uint nSizeMeanDiff,	//output 
											 double	 *vLCIs, uint nSizeLCI,
											 double	 *vUCIs, uint nSizeUCI,
											 double	 *dSe, uint nSizeSe,
											 double	 *vSig, uint nSizeSig,
											 int iTestType);

*/
/// END REWRITE_TWOWAYANOVA_MEAN_COMPARISON

/**#
		Two-Way ANOVA function used to compute and output Two-Way ANOVA Power Analysis.
	Example:
		See function stats_anova_two_way above for a sample call.
	Parameter:
		iPower=Input integer specifying whether or not to compute actual and hypothetical
					0 - actual power only
					1 - actual and hypothetical sample size power
		iInteractions=Enable (1) or disable (0) computation of Two-Way ANOVA interactions
		dAlpha=Alpha used to compute Power
		vSS=Input pointer to list of actual or hypothetical sample sizes
		vSSPOW=Outout pointer to all the power computed, vSSPOW[0] is always the actual power 
		iSize=Input size of vSS
		arANOVA2_Table=A four element array of an RegANOVA structure holding all computed F Table
			values having one element for each row of the ANOVA F table (A, B, A * B, and Error)
		iSource=Input flag to decide whose power to be computed
					0 - Factor A Power
					1 - Factor B Power
					2 - Factor A*B Power
	Return:
		Outputs the Two-Way ANOVA Power Analysis table to the Results Log. Returns STATS_NO_ERROR 
		on successful exit or an STATS error code on failure.
*/
OCMATH_API int ocmath_osANOVA2Way_Compute_Power( 
												 int iInteractions,
												 double dAlpha,
												 //int nPts,
												 double *vSS, int iSize,
												 ANOVA2Table *arANOVA2_Table,
												 double *vSSPOW, 
												 //double *dPower,
												 int iSource = 0);
														  

/////////////////////////////////////////////////////////////////////////////////
//
//				Non-Parameter Hypothesis Analysis								
//
/////////////////////////////////////////////////////////////////////////////////	
//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_one_sample_wilcoxon_(global_function)
*/
OCMATH_API int ocmath_one_sample_wilcoxon(const double *pData, const int nSize, const double dMedian,
								  const int nTailType, NPHSummary* Wilco1Summary, NPHStats *Wilco1Stats);
// Comments last updated by Stacy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_mann_whitney_(global_function)
*/
OCMATH_API int ocmath_mann_whitney(const double *pData1, const int nSize1,
								  const double *pData2, const int nSize2, 
								  const int nTailType, NPHSummary *MannSummary, 
								  NPHRanks *MannRanks, NPHStats *MannStats, bool bExact = false);

//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_2_sample_ks_test_(global_function)
*/
OCMATH_API int ocmath_2_sample_ks_test(const double *pData1, const int nSize1,
									   const double *pData2, const int nSize2, 
									   const int nTailType, NPHStats *KSStats);

//Comments last updated by Stacy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_wilcoxon_sign_rank_(global_function)
*/
OCMATH_API	int ocmath_wilcoxon_sign_rank(const double *pData1, const uint nSize1, const double *pData2, const uint nSize2, const int nTailType, NPHSummary *WilSiSummary, 
	NPHRanks *WilSiRanks, NPHStats *WilSiStats);

///Echo 11/17/05 QA70-8304 ADD_SIGN_TEST
//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_sign_test_(global_function)
*/
OCMATH_API	int ocmath_sign_test(const double *pData1, const double *pData2, 
								 const uint nSize, const int nTailType, 
								 int *nTies, NPHFreqs *SignFreqs, NPHStats *SignStats);

// Category last updated by Echo on 06/02/2008
/**# >Statistics>Nonparametric Tests
		Performs a Kruskal-Wallis test for identical population medians. The main engine 
		is nag_kruskal_wallis_test.
	Example:
	Parameter:
		pData=Input pointer to data points
		nSize=Input number of data points
		iLevels=Input number of groups
		pIndex=Input pointer the data number of each group.
		KruSummary=Output pointer to structure containing summary statistics of each groups
						KruSummary[i-1]: Summary statistics of i-th group
		KruRanks=Output pointer to structure containing Statistics of Ranks
					KruRanks[i-1]: Ranks of i-th group
		KruStats=Output pointer to structure containing the test statistic and p-value, No corrected for ties.
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/	
OCMATH_API int ocmath_kruskal_wallis_anova(const double *pData, const uint nSize, const int iLevels, const double *pIndex,
	NPHSummary *KruSummary, NPHRanks *KruRanks, NPHStats *KruStats);

///Echo 11/17/05 QA70-8306 ADD_MEDIAN_TEST
// Comments last updated by Stacy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_median_test_(global_function)
*/
OCMATH_API int ocmath_median_test(const double *pData, const uint nSize, const int iLevels, const double *pIndex,
	NPHFreqs *MdFreqs, NPHStats *MdStats);

// Comments last updated by Stacy on 7/30/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_friedman_test_(global_function)
*/
OCMATH_API int ocmath_friedman_test(const double *pData, const uint nSize,
									 const double *dpTreaments, const uint nTreatmSize,
									 const double *dpBlocks, const uint nBlockSize,
									 NPHSummary *FriSummary, NPHRanks *FriRanks, NPHStats *FriStats);
// Category last updated by Echo on 06/02/2008
/**# >Statistics>Nonparametric Tests
		Compute Mean Ranks and Sum of Ranks for Nonparametric Tests of Paired samples
	Example:
	Parameter:
		pData1=Input pointer to 1st data points for Wilcoxon Rank Sum test
		nSize1=Input number of pData1
		pData2=Input pointer to 2nd data points for Wilcoxon Rank Sum test
		nSize2=Input number of pData2
		dPosRankSum=Output value indicates the sum of positive ranks
		dPosRankMean=Output value indicates the mean of positive ranks
		dNegRankSum=Output value indicates the sum of negative ranks
		dNegRankMean=Output value indicates the mean of negative ranks
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure
*/
OCMATH_API int ocmath_paired_samples_ranks(const double *pData1, const uint nSize1, 
										   const double *pData2, const uint nSize2,
										   double *dPosN, double *dNegN,
										   double *dPosRankSum, double *dPosRankMean,
										   double *dNegRankSum, double *dNegRankMean);

// Category last updated by Echo on 06/02/2008
/**# >Statistics>Nonparametric Tests
		Compute Mean Ranks and Sum of Ranks for Nonparametric Tests of two samples
	Example:
	Parameter:
		pData1=Input pointer to 1st data points for Wilcoxon Rank Sum test
		nSize1=Input number of pData1
		pData2=Input pointer to 2nd data points for Wilcoxon Rank Sum test
		nSize2=Input number of pData2
		dPosRankSum=Output value indicates the sum of positive ranks
		dPosRankMean=Output value indicates the mean of positive ranks
		dNegRankSum=Output value indicates the sum of negative ranks
		dNegRankMean=Output value indicates the mean of negative ranks
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure
*/
OCMATH_API int ocmath_two_samples_ranks(const double *pData1, const uint nSize1, 
										const double *pData2, const uint nSize2,
										double *dRankSum1, double *dRankMean1,
										double *dRankSum2, double *dRankMean2);

// Category last updated by Echo on 06/02/2008
/**# >Statistics>Nonparametric Tests
		Compute Mean Ranks and Sum of Ranks for Kruskal Wallis ANOVA
	Example:
	Parameter:
		pData=Input pointer to data points
		nSize=Input size of pData
		iLevels=Input number of groups
		pIndex=Input pointer to the data number of each group
		dpRankSums=Ouput pointer to the sum of ranks of each group
		nRankSumSize=Input size of dpRankSums. It should not less than iLevels
		dpRankMeans=Output pointer to the mean of ranks of each group
		nRankMeanSize=Input size of dpRankMeans. It should not less than iLevels
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure
*/
OCMATH_API int ocmath_kruskal_wallis_ranks(const double *pData, const uint nSize,
										const uint iLevels, const double *pIndex,
										double *dpRankSums,  const uint nRankSumSize,
										double *dpRankMeans, const uint nRankMeanSize);

// Category last updated by Echo on 06/02/2008
/**# >Statistics>Nonparametric Tests
		Compute Mean Ranks and Sum of Ranks for Friedmans ANOVA
	Example:
	Parameter:
		pData=Input pointer to data points
		nSize=Input size of pData
		dpBlocks=Input pointer to integerized blocks.
		nBlockSize=Input size of dpBlocks. it should not less than nSize
		dpTreaments=Input pointer to integerized treaments
		nTreatmSize=Input size of dpTreaments, it should not less than nSize 
		dpRankSums=Ouput pointer to the sum of ranks of each group
		nRankSumSize=Input size of dpRankSums. It should not less than maximum of dpBlock
		dpRankMeans=Output pointer to the mean of ranks of each group
		nRankMeanSize=Input size of dpRankMeans. It should not less than maximum of dpBlock
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure
*/
OCMATH_API int ocmath_friedman_ranks(const double *pData, const uint nSize,
									 const double *dpBlocks, const uint nBlockSize,
									 const double *dpTreaments, const uint nTreatmSize,
									 double *dpRankSums,  const uint nRankSumSize,
									 double *dpRankMeans, const uint nRankMeanSize);

/////////////////////////////////////////////////////////////////////////////////
//
//				Survival Analysis Functions									
//
/////////////////////////////////////////////////////////////////////////////////
	 
//Comments last updated by Stacy on 7/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_kaplan_meier_surviv_fn_(global_function)
*/
OCMATH_API int	ocmath_kaplan_meier_surviv_fn(const double* pTime, uint nTime, const double* pCensor, uint nCensor, const double* pCensored, uint nCensoredVal, const double dConLevel,
	SAEstim *psSurvivEstim, uint nSizeSAEstm, SAQuantEst *psSAQuantEstim, uint nSizeQuanEstm, SASummary* stSASumStats, SAMeanEst* pSAMeanEst = NULL);	 

///Echo 1/18/05 QA70-8231 ADD_LIFE_TABLE
/**#
		Compute estimates of life tables (survival analysis)
	Parameter:
		nSize = [input] size of time values, frequency values and censor values
		pFreq = [input] pointer to the frequency values
		pTime = [input] pointer to time values
		pCensor = [input] pointer to censor values
		nCensored = [input] size of censored values, which needs to be less than 20
		pCensored = [input] pointer to Censored value. Please make sure that value of pCensored are all in pCensor and value are unduplicated. 
		pTimeInvl = [input] pointer to elements of time interval. Size of the pointer should be 3
					1st: Start time
					2nd: End time
					3rd: Time interval width
		nSALifeTbl =[input] Size of the SALifeTbl, which should be larger than (pTimeInvl[2] - pTimeInvl[1]) / pTimeInvl[3]
		pSALifeTbl = [output] pointer to structure SALifeTbl, containing estimates of life table
		stSASumStats=Output pointer to structure containing summary of event and censored values 
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/
OCMATH_API int	ocmath_life_table(uint nSize, const double* pTime, const double* pFreq, const double* pCensor, 
								  uint nCensored, const double* pCensored, const double* pTimeInvl, 
								  uint nSALifeTbl, SALifeTbl* pSALifeTbl, SASummary* stSASumStats);	 

///Echo 11/03/05 QA70-6217	ADD_SURVIV_FN_COMP
// Category last updated by Echo on 06/02/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_surviv_fn_comp_(global_function)
*/
OCMATH_API int	ocmath_surviv_fn_comp(const double* pTime, uint nTime, const double* pCensor, uint nCensor, const double* pFactor, uint nFactor, const double* pCensored, uint nCensoredVal, SFComp* psSFComp, int nMethod = 0);	 

// Category last updated by Echo on 06/02/2008
/**# >Statistics>Survival Analysis
		Survival Analysis function used to compute parameter estimates and other statistics associated with 
		the Cox Proportional Hazards Model for fixed covariates.
	Parameter:
		pTime=Input  pointer to time values
		nTime=Input size of time values
		pCensor=Input pointer to censor values
		nCensor=Input size of censor values
		pCensored=Input pointer to Censored value. Please make sure that value of pCensored are all in pCensor and value are unduplicated.
		nCensoredVal=Input size of censored value, which needs to be less than 20
		pCovars=Input pointer to containing predictor variables (covariates)
		nCovarCol=Input column number of Covariate matrix
		nCovarRow=Input row number of corvariate matrix
		stSASummary=Output pointer to summary of event and censored values 
		psSAFitStats=Output pointer to the statistics assessing the overall fit of model
		psSAParaEstim=Output pointer to parameter estimates 
		nSizeParaEstm=Input size (number of structure) of psSAParaEstim. It should not be less than the number of covariates
		psSurvivEstim= Output pointer to the Survival Analysis of time
		nSizeSAEstm=Input size (number of structure) of psSurvivEstim. it should not be less than size of vTime		
		pCov=Output pointer to variance-covariance matrix
		pCorr=Output pointer to correlation matrix
		nCovCorrCol=Input column size of variance-covariance and correlation matrix
		nCovCorrRow=Input row size of variance-covariance and correlation matrix
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/	 
OCMATH_API int	ocmath_surviv_cox_model(const double* pTime, uint nTime, const double* pCensor, uint nCensor, const double* pCensored, uint nCensoredVal, double* pCovars, uint nCovarCol, uint nCovarRow,
	SASummary *stSASummary, SAFitStats *stSAFitStats, SAParaEstim *psSAParaEstim, uint nSizeParaEstm, SAEstim *psSurvivEstim, uint nSizeSAEstm, double* pCov=NULL, double* pCorr=NULL, uint nCovCorrCol=0, uint nCovCorrRow=0);
	
	
// Category last updated by Echo on 06/02/2008
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_surviv_weibull_simple_(global_function)
*/
OCMATH_API int	ocmath_surviv_weibull_simple(const double* pTime, uint nTime, const double* pCensor, uint nCensor, const double* pCensored, uint nCensoredVal, const double dConfLevel, 
	double *pCriterion, SASummary* psSASummary, SAParaEstim *psSAParaEstim, uint nSizeParaEstim);

/**#
		Survival Analysis function used to compute the parameter estimates and other 
		statistics that are associated with the Weibull model. The main engine is 
		imsls_d_survival_glm.
	Example:
	Parameter:
		vTime=Input vector containing time values
		pTime=Input pointer to time values
		nTime=Input size of time values.
		pCensor=Input pointer to censor values
		nCensor=Input size of censor values
		pCensored=Input pointer to Censored value. Please make sure that value of pCensored are all in pCensor and value are unduplicated. 
		nCensoredVal=Input size of censored values, which needs to be less than 20
		pClass=Input pointer to the classification variables
		nClassCol=Input column of classification variables
		nClassRow=Input row of classification
		pContinuous=Input pointer to the continuous variable.
		nContinCol=Input column of continuous variable
		nContinRow=Input row of continuous variable
		dCriterion=Optimized criterion.The criterion to be maximized is a constant plas the log-likehood. 
		psSASummary=Output structure containing summary of event and censored values. 
		psSAParaEstim=Output structure containing parameter estimates. 
		nSizeParaEstm=Output size (number of structure) of psSAParaEstim.
		psSurvivEstim= Output structure containing the Survival Analysis of time
		nSizeSAEstm=Input size (number of structure) of psSurvivEstim. it should not be less than size of vTime				
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/	 
OCMATH_API int	ocmath_surviv_weibull(const double* pTime, uint nTime, const double* pCensor, uint nCensor, const double* pCensored, uint nCensoredVal, const double* pClass, uint nClassCol, uint nClassRow, const double* pContinuous, uint nContinCol, uint nContinRow,
	double& dCriterion, SASummary* psSASummary, SAParaEstim *psSAParaEstim, int& nSizeParaEstm, SAEstim *psSurvivEstim, uint nSizeSAEstm);

	
/**$
		List out the unduplicated censored value in pCensor
	Parameter:
		pCensor=Input pointer to censor values
		nCensor=Input size of censor values.
		pCensList=Output pointer to all unduplicated censor values. 
		nCensList=Input size of pCensList.
		nOutCens=Output number of unduplicated censor values. 
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/			
OCMATH_API int	ocmath_censored_value_list(const double* pCensor, uint nCensor, double* pCensList, uint nCensList, int* nOutCens);
	
/**#
		Calculates Spearman rank correlation coefficients
	Parameter:
		pData=Input pointer to data points
		nSize=Input number of data points
		iLevels=Input number of groups
		pIndex=Input pointer the data number of each group.
		pCorr=Output pointer to matrix of correlation coefficients. Size of matrix should be iLevels * iLevels.
		pSig=Output pointer to matrix of correlation significants. Size of matrix should be iLevels * iLevels. Diagonal should be NANUM;
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.	
*/			
//OCMATH_API int ocmath_pea_corr_coeff(const double *pData, uint nSize, const int iLevels, const int *pIndex, double *pCorr, double *pSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);
OCMATH_API int ocmath_pea_corr_coeff(UINT nRows, UINT nCols, const double *pData, double *pCorr, double *pSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);

	
/**#
		Calculates Spearman rank correlation coefficients
	Parameter:
		pData=Input pointer to data points
		nSize=Input number of data points
		iLevels=Input number of groups
		pIndex=Input pointer the data number of each group.
		pCorr=Output pointer to matrix of correlation coefficients. Size of matrix should be iLevels * iLevels.
		pSig=Output pointer to matrix of correlation significants. Size of matrix should be iLevels * iLevels. Diagonal should be NANUM;
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/			
//OCMATH_API int ocmath_spe_corr_coeff(const double *pData, uint nSize, const int iLevels, const int *pIndex, double *pCorr, double *pSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);
OCMATH_API int ocmath_spe_corr_coeff(UINT nRows, UINT nCols, const double *pData, double *pCorr, double *pSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);


/**#
		Calculates Kendall rank correlation coefficients
	Parameter:
		pData=Input pointer to data points
		nSize=Input number of data points
		iLevels=Input number of groups
		pIndex=Input pointer the data number of each group.
		pCorr=Output pointer to matrix of correlation coefficients. Size of matrix should be iLevels.
		pSig=Output pointer to matrix of correlation significants. Size of matrix should be iLevels. Diagonal should be NANUM;
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/			
//OCMATH_API int ocmath_ken_corr_coeff(const double *pData, uint nSize, const int iLevels, const int *pIndex, double *pCorr, double *pSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);
OCMATH_API int ocmath_ken_corr_coeff(UINT nRows, UINT nCols, const double *pData, double *pCorr, double *pSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);

// Comments last updated by Army 07/29/2009
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ocmath_corr_coeff_(global_function)
*/
OCMATH_API int ocmath_corr_coeff(UINT nRows, UINT nCols, const double *pData, double *pPeaCorr, double *pPeaSig, double *pSpeCorr, double *pSpeSig, double *pKenCorr, double *pKenSig, int nExcludeMissing = CORR_EXCLUDE_MISSING_PAIRWISE);

/////////////////////////////////////////////////////////////////////////////////
//
//				ROC Curve									
//
/////////////////////////////////////////////////////////////////////////////////
/**$
	Function for ROC curve, finds the hit rates in dataset over a range of thresholds.
	Hits are "true positives" in one dataset and "false positives" in the other and the
	plot of true positive probality(TPP) versus false positive probability(FPP) is called
	the receive operating charateristic(ROC) curve. A ROC curve is a visual tool for examining
	tradeoffs between the sensitivity and selectivity of a classifier. 
	Parameter:
		pData=Input pointer to data points. 
		nSize=Input the number of observations, n. n>=2
		pState=Input pointer to state variable 
		nState=Input number of state variable, which must be equal to nSize
		pStaValList=Input pointer to Value list state variable.
		nStaValList=Input number of value list of state variable.
		psROCArea = Output pointer to structure of related variables of Area under ROC curve
		psROC = Output pointer to structure to ROC curve coordinate points.
		nROC=Input size of ROC curve coordinate. 
		dConfLevel=Input confidence level for confidence band of area under the curve. 
		nThdFlag=Input flag for Threshold List defination. 
			nThdFlag=ROC_INTERPOLATION,  Thresholds are interpolation of data points
			nThdFlag=ROC_SPEED_MODE, Thredholds are bounds for 100 equally spaced intervals
			nThdFlag=ROC_USER_DEFINED, Using user defined threshold list
		pThres=Input user defined threshold list. Usable only if nThdFlag=ROC_USER_DEFINED
		nThres=INput size of user defined threshold list.
*/
OCMATH_API int ocmath_roc_curve(const double *pData, uint nSize, const double* pState, uint nState, const double *pStaValList, uint nStaValList, ROCArea *psROCArea, ROCCuv *psROC, uint nROC, double dConfLevel = 0.95, int nThdFlag = 0, const double* pThres = NULL, uint nThres = 0);

/**$
		Compute the size of threshold in ROC curve when using methods other than user defined. 
	Parameter:
		pData=Input pointer to data points
		nData=Input size of data points.
		nOutThres=Output number of threshold
		nThdFlag=Input flag for Threshold List defination. 
			nThdFlag=ROC_INTERPOLATION,  Thresholds are interpolation of data points
			nThdFlag=ROC_SPEED_MODE, Thredholds are bounds for 100 equally spaced intervals
	Return:
		Returns STATS_NO_ERROR on successful exit or an STATS error code on failure.
*/			
OCMATH_API int	ocmath_threshold_list(const double* pData, uint nData, int* nOutThres, int nThdFlag = 0);


//Ben 09/20/05 ADD_PDF_CDF
// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:betapdf_(global_function)
*/
OCMATH_API double betapdf(const double x, double a, double b, int* nFail = NULL );

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wblpdf_(global_function)
*/
OCMATH_API double wblpdf(const double x, double a, double b, int* nFail = NULL );

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wblcdf_(global_function)
*/
OCMATH_API double wblcdf(const double x, double a, double b, int* nFail = NULL );

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:betacdf_(global_function)
*/
OCMATH_API double betacdf(const double x, double a, double b, int iTail = TAILED_TEST_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:bivarnormcdf_(global_function)
*/
OCMATH_API double bivarnormcdf(const double x, const double y, double rho, int* nFail = NULL)  ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:chi2cdf_(global_function)
*/
OCMATH_API double chi2cdf(const double x, double df, int iTail = TAILED_TEST_LOWER, int* nFail = NULL)  ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:fcdf_(global_function)
*/
OCMATH_API double fcdf(const double dF, double df1, double df2, int iTail = TAILED_TEST_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gamcdf_(global_function)
*/
OCMATH_API double gamcdf(const double dG, double a, double b, int iTail = TAILED_TEST_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ncbetacdf_(global_function)
*/
///---------Zachary  04/14/06  QA8482  PARAMETER_NSIZE_IS_NOT_USED_IN_NCBETACDF.
//as NAG's suggestion, the nSize is set as a constant 500, so the nSize parameter is not used.
//OCMATH_API double ncbetacdf(const double dX, const uint nSize, double a, double b, double lambda, int* nFail = NULL) ;
OCMATH_API double ncbetacdf(const double dX, double a, double b, double lambda, int* nFail = NULL) ;
//----------End PARAMETER_NSIZE_IS_NOT_USED_IN_NCBETACD.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ncchi2cdf_(global_function)
*/
OCMATH_API double ncchi2cdf(const double dX, double df, double lambda, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:ncfcdf_(global_function)
*/
OCMATH_API double ncfcdf(const double dF, double df1, double df2, double lambda, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:nctcdf_(global_function)
*/
///------- Zachary  04/18/06  REWRITE_NCTCDF
//OCMATH_API double nctcdf(const double dT, double df1, double df2, double lambda, int* nFail = NULL) ;
OCMATH_API double nctcdf(const double dT, double df, double delta, int* nFail = NULL) ;
///------- End 	REWRITE_NCTPDF

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:normcdf_(global_function)
*/
OCMATH_API double normcdf(const double dX, int iTail = TAILED_TEST_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:srangecdf_(global_function)
*/
OCMATH_API double srangecdf(const double dQ, double v0, int ir, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tcdf_(global_function)
*/
OCMATH_API double tcdf(const double dT, double df, int iTail = TAILED_TEST_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:binocdf_(global_function)
*/
OCMATH_API double binocdf(const int iK, int n, double p, int iTail = TAILED_TEST_DISC_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:hygecdf_(global_function)
*/
OCMATH_API double hygecdf(const int iK, int m, int n, int l, int iTail = TAILED_TEST_DISC_LOWER, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:poisscdf_(global_function)
*/
OCMATH_API double poisscdf(const int iK, double rlamda, int iTail = TAILED_TEST_DISC_LOWER, int* nFail = NULL) ;

//End ADD_PDF_CDF

//Ben 09/21/05 ADD_IN_CDF_RANDOM_NO
// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wblinv_(global_function)
*/
OCMATH_API double wblinv(const double p, double a, double b, int* nFail = NULL );

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:betainv_(global_function)
*/
OCMATH_API double betainv(const double dP, double a, double b, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:chi2inv_(global_function)
*/
OCMATH_API double chi2inv(const double dP, double df, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:finv_(global_function)
*/
OCMATH_API double finv(const double dP, double df1, double df2, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gaminv_(global_function)
*/
OCMATH_API double gaminv(const double dP, double a, double b, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:norminv_(global_function)
*/
///Human 10/14/05 REPLACE_NORMINV 
//OCMATH_API double norminv(const double dP, int iTail, int* nFail = NULL)
OCMATH_API double norminv(const double dP, int* nFail = NULL) ;
///END REPLACE_NORMINV 

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:srangeinv_(global_function)
*/
OCMATH_API double srangeinv(const double dP, double v0, int ir, int* nFail = NULL) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:tinv_(global_function)
*/
///Zachary 07/07/06 ADD_DEFAULT_VALUE_FOR_TAIL_OF_TINV
OCMATH_API double tinv(const double dP, double df, int iTail = TAILED_TEST_DISC_LOWER, int* nFail = NULL) ;
//OCMATH_API double tinv(const double dP, double df, int iTail, int* nFail = NULL) ;
///END ADD_DEFAULT_VALUE_FOR_TAIL_OF_TINV

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:binornd_(global_function)
*/
OCMATH_API int binornd(long *v, uint n, int m, double p) ;///Cloud 10/24/2005 //the head file define should is the same with source file.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:disrnd_(global_function)
*/
OCMATH_API int disrnd(long* v, uint n, const double* vP, const uint nSizeP, int iLowerIndex, bool bIsCdf) ;///Cloud 10/24/2005 //the head file define should is the same with source file.

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:geornd_(global_function)
*/
OCMATH_API int geornd(long *v, uint n, double p) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:hygernd_(global_function)
*/
OCMATH_API int hygernd(long* v, uint n, int ns, int np, int m) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:nbinrnd_(global_function)
*/
OCMATH_API int nbinrnd(long* v, uint n, int m, double p) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:unidrnd_(global_function)
*/
OCMATH_API int unidrnd(long* v, uint n, int a, int b) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:poissrnd_(global_function)
*/
OCMATH_API int poissrnd(long* v, uint n, double lamda) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:permrnd_(global_function)
*/
OCMATH_API int permrnd(long* pV, uint n) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:betarnd_(global_function)
*/
OCMATH_API int betarnd(double* v, uint n, double a, double b) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:caurnd_(global_function)
*/
OCMATH_API int caurnd(double* v, uint n, double xmed, double semiqr) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:chi2rnd_(global_function)
*/
OCMATH_API int chi2rnd(double* v, uint n, int df) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:exprnd_(global_function)
*/
OCMATH_API int exprnd(double* v, uint n, double a) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:frnd_(global_function)
*/
OCMATH_API int frnd(double* v, uint n, int df1, int df2) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:gamrnd_(global_function)
*/
OCMATH_API int gamrnd(double* v, uint n, double a, double b) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lgsrnd_(global_function)
*/
OCMATH_API int lgsrnd(double* v, uint n, double a, double b) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:lognrnd_(global_function)
*/
OCMATH_API int lognrnd(double* v, uint n, double xmu, double var) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:trnd_(global_function)
*/
OCMATH_API int trnd(double* v, uint n, int df) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:trirnd_(global_function)
*/
OCMATH_API int trirnd(double* v, uint n, double xmin, double xmax, double xmed) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:wblrnd_(global_function)
*/
OCMATH_API int wblrnd(double* v, int n, double a, double b) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:normrnd_(global_function)
*/
OCMATH_API int normrnd(double* v, uint n, double xmu, double var) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:unifrnd_(global_function)
*/
OCMATH_API int unifrnd(double* v, uint n, double a, double b) ;

// Category last updated by Echo on 03/22/2007
/**+
http://ocwiki.originlab.com/index.php?title=OriginC:mvnrnd_(global_function)
*/
OCMATH_API int mvnrnd(double* v, uint n, int nDim, const double* pMean, const double* mCov) ;


//End ADD_IN_CDF_RANDOM_NO

OCMATH_API	double	ocmath_absolute_arithmetic_average(const double *pData, UINT nSize);
OCMATH_API	double	ocmath_root_mean_square(const double *pData, UINT nSize);
OCMATH_API	double	ocmath_skewness(const double *pData, UINT nSize, double rms = -1.0);
OCMATH_API	double	ocmath_kurtosis(const double *pData, UINT nSize, double rms = -1.0);

/// Fisher 04/08/10 QA85-15176-P2 NATURAL_AXES_FINDING 
OCMATH_API	int	ocmath_us_find_natural_axes(const UINT *px, const UINT *py, UINT nSize, double *vx, double *vy);
/// --------------

#ifdef _MSC_VER
	}
#endif	//_MSC_VER

//////////////////////////////////////////////////////////////////////////
#endif _OC_STATS_H
